﻿/*
VERSION:	1.0

DECRIPTION:
	This system is meant to be used with the  walkInertia.as  style of movement.
	It collides with other movieClips on the sprite layer.

AVAILABLE DATA:
	This returns a collision function which changes its parent's objects & properties.
	The parent collision system (this) contains:
		xOffset, yOffset
		player_mc
			_x, _y
		collision_array
		walk_obj
			xVel, yVel
	
*/
function makeSpriteCollision()
{
	var collision_funct = function()
	{
		// define size
		var size = 5;		// 5 pixels in all directions
		
		// extract velocities
		var xVel = this.walk_obj.xVel;
		var yVel = this.walk_obj.yVel;
		
		for(var nam in this.spriteLayer_mc)
		{
			var thisSprite = this.spriteLayer_mc[nam];
			if(thisSprite != this.player_mc)
			{
				
				// horz
				// get direction
				var xDir = Math.abs(xVel) / xVel;
				if(xDir)
				{
					// make top-right OR top-left point  +  velocity	(map-relative)	(top)
					var xCheck = this.player_mc._x + (size*xDir) + xVel + this.xOffset;
					var yCheck = this.player_mc._y - size + this.yOffset;
					// store collision ID of top-right point
					if( xCheck > thisSprite._x  &&
						yCheck > thisSprite._y  &&
						xCheck < thisSprite._x+16  &&
						yCheck < thisSprite._y+16)
					{
						var topCollision = 1;
					}else{
						var topCollision = 0;
					}
					// make bottom-right OR bottom-left point  +  velocity	(map-relative)	(bottom)
					var xCheck = this.player_mc._x + (size*xDir) + xVel + this.xOffset;
					var yCheck = this.player_mc._y + size + this.yOffset;
					// store collision ID of bottom-right point
					if( xCheck > thisSprite._x  &&
						yCheck > thisSprite._y  &&
						xCheck < thisSprite._x+16  &&
						yCheck < thisSprite._y+16)
					{
						var bottomCollision = 1;
					}else{
						var bottomCollision = 0;
					}
					// if top or bottom point collided
					if( topCollision != 0  ||
						bottomCollision != 0)
					{// if:  A horz point collided
						// reset horz velocity
						this.walk_obj.xVel = 0;
					}// if:  A horz point collided
				}// if:  horz movement
				
				
				
				// vert
				// get direction
				var yDir = Math.abs(yVel) / yVel;
				if(yDir)
				{
					// make left-top OR left-bottom point  +  velocity	(map-relative)	(left)
					var xCheck = this.player_mc._x - size + this.xOffset;
					var yCheck = this.player_mc._y + (size*yDir) + yVel + this.yOffset;
					// store collision ID of left-top point
					if( xCheck > thisSprite._x  &&
						yCheck > thisSprite._y  &&
						xCheck < thisSprite._x+16  &&
						yCheck < thisSprite._y+16)
					{
						var leftCollision = 1;
					}else{
						var leftCollision = 0;
					}
					// make right-top OR right-bottom point  +  velocity	(map-relative)	(right)
					var xCheck = this.player_mc._x + size + this.xOffset;
					var yCheck = this.player_mc._y + (size*yDir) + yVel + this.yOffset;
					// store collision ID of right-top point
					if( xCheck > thisSprite._x  &&
						yCheck > thisSprite._y  &&
						xCheck < thisSprite._x+16  &&
						yCheck < thisSprite._y+16)
					{
						var rightCollision = 1;
					}else{
						var rightCollision = 0;
					}
					// if left or right collided
					if( leftCollision != 0  ||
						rightCollision != 0)
					{// if:  A vert point collided
						// reset horz velocity
						this.walk_obj.yVel = 0;
					}// if:  A vert point collided
				}// if:  vert movement
			}// if:  thisSprite isn't the player
		}// for...in:  spriteLayer_mc
	}// collision_funct()
	
	return collision_funct;
}// makeSpriteCollision()